<?php
/**
 * @version    2.7.x
 * @package    K2
 * @author     JoomlaWorks http://www.joomlaworks.net
 * @copyright  Copyright (c) 2006 - 2016 JoomlaWorks Ltd. All rights reserved.
 * @license    GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 */

// no direct access
defined('_JEXEC') or die;
// includes placehold
$yt_temp = JFactory::getApplication()->getTemplate();
include (JPATH_BASE . '/templates/'.$yt_temp.'/includes/placehold.php');
if(!function_exists('otherDiffDate')) {
	function otherDiffDate($end='2015-03-19 10:30:00'){
		$intervalo = date_diff(date_create(), date_create($end));
		if(!empty($intervalo)){
			$_date_time = array(); $i = 0;
			foreach($intervalo as $inter){ $i++;
				if($i <= 5){
					$_date_time[] = $inter;
				}
			}
			$str = '';
			if(!empty($_date_time)){
				$_labels = array('year','month','day','hour','minute', 'second');
				 for($i = 0; $i <= count($_date_time) ; $i++){
					 if($_date_time[$i] > 0){
						if($_date_time[$i] <= 1){
							$str .= $_date_time[$i].' '.$_labels[$i].' ago'; 
						}else{
							$str .= $_date_time[$i].' '.$_labels[$i].'s ago';  
						}
						 break;
					 }
				 }
			}
			return $str;
		
		}
	}
}
?>
<div id="k2ModuleBox<?php echo $module->id; ?>" class="style-latest k2ItemsBlock<?php if($params->get('moduleclass_sfx')) echo ' '.$params->get('moduleclass_sfx'); ?>">

	<?php if($params->get('itemPreText')): ?>
	<p class="modulePretext"><?php echo $params->get('itemPreText'); ?></p>
	<?php endif; ?>
	<div class="row">
	<?php if(count($items)): ?>
    <?php foreach ($items as $key=>$item):	?>
		<div class="col-xs-6 col-sm-12 col-md-4">
			<div class="catItemBody">
				<div class="catItemImageBlock">
						<a href="<?php echo $item->link; ?>" title="<?php echo K2HelperUtilities::cleanHtml($item->title); ?>">
							<?php 	
								//Create placeholder items images
								if(isset($item->image)){
								$src =$item->image;  }
								if (!empty( $src)) {								
									$thumb_img = '<img src="'.$src.'" alt="'.$item->title.'" />'; 
								} else if ($is_placehold) {					
									$thumb_img = yt_placehold($placehold_size['img_latest'],$item->title,$item->title); 
								   //var_dump( $thumb_img);
								}	
								echo $thumb_img;
							?>
						</a>
						<?php if($params->get('itemDateCreated')): ?>
						<div class="date">
							<span class="day">
								<?php echo JHTML::_('date', $item->created, JText::_('d')); ?>
							</span>
							<span class="month">
								<?php echo JHTML::_('date', $item->created, JText::_('M')); ?>
							</span>
						</div>
						<?php endif; ?>
				</div>
				<div class="content">
					<?php if($params->get('itemTitle')): ?>
						<h3 class="catItemTitle"><a  href="<?php echo $item->link; ?>"><?php echo $item->title; ?></a></h3>
					<?php endif; ?>
					<div class="info">
						 <?php if($params->get('itemAuthor')): ?>
							<span class="post-by"><?php echo JText::_('POST_BY'); ?></span>
							<?php if(isset($item->authorLink)): ?>
							<a class="author" rel="author" title="<?php echo K2HelperUtilities::cleanHtml($item->author); ?>" href="<?php echo $item->authorLink; ?>"><?php echo $item->author; ?></a>
							<?php else: ?>
							<span class="author"> <?php echo $item->author; ?></span>
							<?php endif; ?>
						<?php endif; ?>
						&nbsp; &ndash; &nbsp; 
						<?php if($params->get('itemDateCreated')): ?>
						<span class="date-ago">
						<?php 
							$_date = JHTML::_('date',$item->created, 'Y-m-d H:m:s');
							echo otherDiffDate($_date); ?>
						</span>
						<?php endif; ?>
					</div>
					<?php if($params->get('itemIntroText')): ?>
					<div class="intro"><?php echo $item->introtext; ?></div>
					<?php endif; ?>
				</div>
			</div>
		</div>
	<?php endforeach; ?>
	<?php endif; ?>
	</div>
</div>
