<?php
/**
 * @version    2.7.x
 * @package    K2
 * @author     JoomlaWorks http://www.joomlaworks.net
 * @copyright  Copyright (c) 2006 - 2016 JoomlaWorks Ltd. All rights reserved.
 * @license    GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 */

// no direct access
defined('_JEXEC') or die;
// includes placehold
$yt_temp = JFactory::getApplication()->getTemplate();
include (JPATH_BASE . '/templates/'.$yt_temp.'/includes/placehold.php');

?>

<div id="k2ModuleBox<?php echo $module->id; ?>" class="style-list k2ItemsBlock<?php if($params->get('moduleclass_sfx')) echo ' '.$params->get('moduleclass_sfx'); ?>">

	<?php if($params->get('itemPreText')): ?>
	<p class="modulePretext"><?php echo $params->get('itemPreText'); ?></p>
	<?php endif; ?>
	<?php if(count($items)): ?>
    <?php foreach ($items as $key=>$item):	?>
		<div class="catItemBody">
			<div class="catItemImageBlock">
				<div class="catItemImage">
					<a href="<?php echo $item->link; ?>" title="<?php echo K2HelperUtilities::cleanHtml($item->title); ?>">
						<?php 	
							//Create placeholder items images
							if(isset($item->image)){
							$src =$item->image;  }
							if (!empty( $src)) {								
								$thumb_img = '<img src="'.$src.'" alt="'.$item->title.'" />'; 
							} else if ($is_placehold) {					
								$thumb_img = yt_placehold($placehold_size['small'],$item->title,$item->title); 
							   //var_dump( $thumb_img);
							}	
							echo $thumb_img;
						?>
					</a>
				</div>
			</div>
			<div class="catItemHeader">
				<?php if($params->get('itemTitle')): ?>
					<h3 class="catItemTitle font-title"><a  href="<?php echo $item->link; ?>"><?php echo $item->title; ?></a></h3>
				<?php endif; ?>
				<!-- Item Rating -->
				<div class="itemRatingBlock">
					<!--<span><?php //echo JText::_('K2_RATE_THIS_ITEM'); ?></span>-->
					<div class="itemRatingForm">
						<ul class="itemRatingList">
							<li class="itemCurrentRating" style="width:<?php echo $item->votingPercentage; ?>%;"></li>
							<li><a href="#" data-id="<?php echo $item->id; ?>" title="<?php echo JText::_('K2_1_STAR_OUT_OF_5'); ?>" class="one-star">1</a></li>
							<li><a href="#" data-id="<?php echo $item->id; ?>" title="<?php echo JText::_('K2_2_STARS_OUT_OF_5'); ?>" class="two-stars">2</a></li>
							<li><a href="#" data-id="<?php echo $item->id; ?>" title="<?php echo JText::_('K2_3_STARS_OUT_OF_5'); ?>" class="three-stars">3</a></li>
							<li><a href="#" data-id="<?php echo $item->id; ?>" title="<?php echo JText::_('K2_4_STARS_OUT_OF_5'); ?>" class="four-stars">4</a></li>
							<li><a href="#" data-id="<?php echo $item->id; ?>" title="<?php echo JText::_('K2_5_STARS_OUT_OF_5'); ?>" class="five-stars">5</a></li>
						</ul>
						<?php /* <div id="itemRatingLog<?php echo $item->id; ?>" class="itemRatingLog"><?php echo $item->numOfvotes; ?></div> */?>
						<div class="clr"></div>
					</div>
				</div>
				
				<?php foreach ($item->extra_fields as $extraField): ?>
				<?php if(($extraField->value != '')&&($extraField->alias=="Type")): ?>
					<span class="type"><?php echo $extraField->value; ?></span>
				<?php endif; ?>
				<?php endforeach; ?>
			</div>
			<?php if($params->get('itemExtraFields') && count($item->extra_fields)): ?>
			<div class="duration">
				<?php foreach ($item->extra_fields as $extraField): ?>
					<?php if(($extraField->value != '')&&($extraField->alias=="MovieDuration")): ?>
						<span class="duration"><?php echo $extraField->value; ?></span>
					<?php endif; ?>
				<?php endforeach; ?>
			</div>
			<?php endif; ?>
		</div>
	<?php endforeach; ?>
	<?php endif; ?>
</div>
