<?php
/*
 * @package Sj K2 Filter
 * @version 1.1.0
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @copyright (c) 2016 YouTech Company. All Rights Reserved.
 * @author YouTech Company http://www.smartaddons.com
 *
 */

// No direct access.
defined('_JEXEC') or die;

$formid = 'sj-k2-filter-form-'.$module->id;
$itemid = $params->get('set_itemid',0)?$params->get('set_itemid',0):JRequest::getInt('Itemid');
$ajax_filter = $params->get('ajax_filter', 0);
$uniqueid = 'sjk2filter_' . rand().time();

if($mod_layout == "horizontal-layout"){
	$form_layout="horizontal_form";
}else{
	$form_layout="vertical_form";
}

JHtml::_('behavior.tooltip', '.sj-k2-filter-tip', array('hideDelay'=>1500, 'fixed'=>true, 'className' => 'sjk2-tooltip'));
?>

<!--[if lt IE 9]>
<div class="sj-k2-filter msie lt-ie9 <?php echo $class_sfx?>" id="<?php echo $uniqueid; ?>"><![endif]-->
<!--[if IE 9]>
<div class="sj-k2-filter msie <?php echo $class_sfx?>" id="<?php echo $uniqueid; ?>"><![endif]-->
<!--[if gt IE 9]><!-->
<div class="sj-k2-filter <?php echo $mod_layout;?> <?php echo $class_sfx?>" id="<?php echo $uniqueid; ?>"><!--<![endif]-->
	
	<form id="<?php echo $formid; ?>" class="sj-k2-filter-form <?php echo $form_layout;?>" name="<?php echo $formid; ?>" method="POST" action="<?php echo JRoute::_('index.php?option=com_sjk2filter&view=itemlist&Itemid='.$itemid); ?>">
		<div class="row">
			
			<div class="col-md-12">
				<h3 role="heading" class="block-subtitle filter-subtitle"><i class="fa fa-search" aria-hidden="true"></i><?php echo JText::_('FIND_YOUR_COURSES_IN_HERE')?></h3>
				<input type="hidden" name="task" value="search" />
				<?php if(!empty($theme)): ?>
					<input type="hidden" name="theme" value="<?php echo $theme ?>" />
				<?php endif; ?>
				<?php if($catMode): ?>
					<!-- include sub category -->
					<input type="hidden" name="isc" value="1" />
				<?php endif; ?>
				<?php if(!$params->get('display_ordering_box', 1) && $params->get('catOrdering') != "inherit"): ?>
					<input type="hidden" id="ordering" name="ordering" value="<?php echo $params->get('catOrdering'); ?>" />
				<?php endif; ?>
				<?php if(!$filter_by_category): ?>
					<?php echo $categories; ?>
				<?php endif; ?>
				<?php
					if($mod_layout == "horizontal-layout"){
					/*filter by Keyword*/
					if($filter_by_keyword):
				
				?>
		
						<div class="item-box box-search">
							<div class="filter-input filter-field">
								<div class="filter-options-title"><span><?php echo JText::_('MOD_K2_FILTER_KEYWORD')?></span></div>
								<div class="filter-options-content ">
									<input type="text" name="searchword" id="searchword<?php echo $module->id; ?>" class="inputbox"
										   value="<?php echo htmlspecialchars(JRequest::getVar('searchword',''));?>"
										   placeholder="<?php echo JText::_('MOD_K2_FILTER_SEARCH_BY_KEYWORD', ''); ?>"
									/>
								</div>
							</div>
						</div>
					<?php 
					
					endif;
					}
					/*END: filter by Keyword*/
				?>
				<ul id="sjk2filter<?php echo $module->id; ?>" class="filter-options filter-list">
					<?php
						$j = 0;
						if($mod_layout == "vertical-layout"){
							
							$clear = '';
							$style = '';
							/*filter by Keyword*/
							if($filter_by_keyword):
								if($params->get('mod_column') >0 && (($j) % $params->get('mod_column')) == 0){
									$clear = " clear:both;";
								}
								if($mod_column || $clear){
									$style ='style="'.$mod_column.$clear.'"';
								}
								$j++;
								?>
			
								<li <?php echo $style?> class="item-box">
									<div class="filter-input filter-field">
										<div class="filter-options-title"><span><?php echo JText::_('MOD_K2_FILTER_KEYWORD')?></span></div>
										<div class="filter-options-content ">
											<input type="text" name="searchword" id="searchword<?php echo $module->id; ?>" class="inputbox" onfocus="if(this.value == 'Course Search') this.value = '';" onblur="if(this.value=='') this.value='Course Search';"
												   value="<?php echo htmlspecialchars(JRequest::getVar('searchword',''));?>"
												   placeholder="<?php echo JText::_('MOD_K2_FILTER_SEARCH_BY_KEYWORD', ''); ?>"
											/>
										</div>
									</div>
								</li>
							<?php 
								$clear = '';
							endif; 
							/*END: filter by Keyword*/
						}
					?>
		
					<?php 
					if($filter_by_daterange):
						$clear = '';
						$style = '';
						if($params->get('mod_column') >0 && (($j) % $params->get('mod_column')) == 0){
							$clear = " clear:both;";
						}
						if($mod_column || $clear){
							$style ='style="'.$mod_column.$clear.'"';
						}
						$j++;
					?>
						<li <?php echo $style;?> class="item-box">
							<div class="filter-input filter-field">
								<div class="filter-options-title"><span><?php echo JText::_('MOD_K2_FILTER_SEARCH_BY_DATE')?></span></div>
								<div class="filter-options-content ">
									<?php echo $filter_by_daterange; ?>
								</div>
							</div>
						</li>
						<?php $clear = '';?>
					<?php endif; ?>
		
			<?php 
			/*BEGIN: filter by Author*/
			if($filter_by_author): 
			$style = '';
			if($params->get('mod_column') >0 && (($j) % $params->get('mod_column')) == 0){
				$clear = " clear:both;";
			}
			if($mod_column || $clear){
				$style ='style="'.$mod_column.$clear.'"';
			}
			$j++;
		
			?>
				<li <?php echo $style;?> class="item-box"> 
					<div class="filter-input filter-field">
						<?php echo $authors_label?>
						<div class="filter-options-content ">
							<?php echo $authors; ?>
						</div>
					</div>
				</li>
			<?php 
			$clear = '';
			endif; 
			/*END: filter by Author*/
			?>
		
			<?php 
			/*BEGIN: filter by Tags*/
			if($filter_by_tags_display): 
			$style = '';
			if($params->get('mod_column') >0 && (($j) % $params->get('mod_column')) == 0){
				$clear = " clear:both;";
			}
			if($mod_column || $clear){
				$style ='style="'.$mod_column.$clear.'"';
			}
			$j++;
		
			?>
				<li <?php echo $style;?>  class="item-box">
					<div class="filter-input filter-field">
						<?php echo $filter_by_tags_label; ?>
						<div class="filter-options-content ">
							<?php echo $filter_by_tags_display; ?>
						</div>
					</div>
				</li>
			<?php 
			$clear = '';
			endif; 
			/*END: filter by Tags*/
			?>
		
			<?php 
			/*BEGIN: filter by Rating*/
			if($filter_by_rating_display): 
			$style = '';
			if($params->get('mod_column') >0 && (($j) % $params->get('mod_column')) == 0){
				$clear = " clear:both;";
			}
			if($mod_column || $clear){
				$style ='style="'.$mod_column.$clear.'"';
			}
			$j++;
		
			?>
				<li <?php echo $style;?>  class="item-box">
					<div class="filter-input filter-field">
						<div class="filter-options-title"><span><?php echo JText::_('MOD_K2_FILTER_RATING'); ?></span></div>
						<div class="filter-options-content ">
							<?php echo $filter_by_rating_display; ?>
							<div class="range-value clearfix">
								<label class="range-min pull-left"><?php echo JText::_('MOD_K2_FILTER_MIN'); ?> <span class="range-rating-min">1</span></label>
								<label class="range-max pull-right"><?php echo JText::_('MOD_K2_FILTER_MAX'); ?> <span class="range-rating-max">5</span></label>
							</div>
						</div>
					</div>
				</li>
			<?php 
			$clear = '';
			endif; 
			/*END: filter by Rating*/
			?>
		
			<?php
			/*BEGIN: filter by Category*/
			if($filter_by_category){
				$style = '';
				if($params->get('mod_column') >0 && (($j) % $params->get('mod_column')) == 0){
					$clear = " clear:both;";
				}
				if($mod_column || $clear){
					$style ='style="'.$mod_column.$clear.'"';
				}
				$j++;
				?>
				<li <?php echo $style;?>  class="item-box">
					<div class="filter-input filter-field">
						<?php echo $filter_by_category_label; ?>
						<?php echo $categories; ?>
					</div>
				</li>
				<?php
				$clear = '';
			}
		
			/*END: filter by Category*/
			?>
		
			<?php if($list): ?>
				<?php if($mod_layout == 'vertical-layout' && count($list) > 1): ?>
					<li id="sj-extra-field-accordion-<?php echo $module->id; ?>" class="accordion">
						<?php foreach($list as $glist): ?>
							<?php $groupid = $glist['groupid']; ?>
							<h4 class="heading-group heading-group-<?php echo $groupid ?>"><?php echo $glist['group'] ?></h4>
							<div>
								<ul>
									<?php require JModuleHelper::getLayoutPath('mod_sj_k2_filter', 'default_extrafields'); ?>
								</ul>
							</div>
						<?php endforeach; ?>
					</li>
				<?php else: ?>
					<?php //echo "<pre>";print_r($list);die();?>
					<?php foreach($list as $glist): ?>
					<?php require JModuleHelper::getLayoutPath('mod_sj_k2_filter', 'default_extrafields'); ?>
					<?php endforeach; ?>
				<?php endif; ?>
			<?php endif; ?>
		
			<?php if ($params->get('display_ordering_box', 1)): ?>
				<?php
				$style = '';
				if($params->get('mod_column') >0 && (($j) % $params->get('mod_column')) == 0){
					$clear = " clear:both;";
				}
				if($mod_column || $clear){
					$style ='style="'.$mod_column.$clear.'"';
				}
				$j++;
				?>
				<li <?php echo $style; ?>  class="item-box">
					<div class="filter-input filter-field">
						<div class="filter-options-title"><span><?php echo JText::_('MOD_K2_FILTER_ITEM_ORDERING_SELECT_BOX'); ?></span></div>
						<div class="filter-options-content ">
							<?php echo $display_ordering; ?>
						</div>
					</div>			
				</li>
			<?php endif; ?>
		
			<?php
			$style='';
			if($params->get('mod_column') >0 && (($j) % $params->get('mod_column')) == 0){
				$clear = " clear:both;";
			}
			if($mod_column || $clear){
				$style ='style="'.$mod_column.$clear.'"';
			}
			$j++;
			?>
				
			<?php 
			$clear = '';
			?>	
			</ul>
		
			<?php if($params->get('ajax_filter', 0) == 1): ?>
				<input type="hidden" name="tmpl" value="component"/>
			<?php endif; ?>
			</div>

			<div class="col-md-12">
				
				<ul class="list-button">
					<li class="last-item box-submit">
					<?php if($params->get('auto_filter',1) == 0): ?>
						<input class="btn submit" type="submit" name="btnSubmit" value="<?php echo JText::_('MOD_K2_FILTER_SEARCH_NOW'); ?>" />
					<?php endif; ?>
					<?php if($params->get('enable_reset_button',1) == 1): ?>
						<input class="btn reset" type="button" name="btnReset" value="<?php echo JText::_('MOD_K2_FILTER_RESET'); ?>" onclick="sjK2ResetSearch('<?php echo $module->id;?>', '<?php echo $formid; ?>', true);" />
					<?php endif; ?>
					</li>
				</ul>
			</div>
		</div>
		
	</form>

</div>

<?php require JModuleHelper::getLayoutPath($module->module, $layout.'_js');?>

<script type="text/javascript">
/*<![CDATA[*/
window.addEvent('load', function(){
	if($('sjk2filter<?php echo $module->id;?>').getElement('#category_id')){
		sjk2DisplayExtraFields(<?php echo $module->id;?>, $('sjk2filter<?php echo $module->id;?>').getElement('#category_id'), <?php echo $selected_group; ?>);
	}

	<?php if($auto_filter) { ?>
		var f = $('<?php echo $formid; ?>');
		f.getElements('input').each(function(el) {
			el.addEvent('change', function(){
	            if(this.id == 'sdate_<?php echo $module->id; ?>' || this.id == 'edate_<?php echo $module->id; ?>'){
	                var sDate = $('sjk2filter<?php echo $module->id;?>').getElement('#sdate_<?php echo $module->id; ?>').get('value');
	                var eDate = $('sjk2filter<?php echo $module->id;?>').getElement('#edate_<?php echo $module->id; ?>').get('value');
	                if(sDate != '' && eDate != ''){
	                    if(isDate(sDate) && isDate(eDate)){
	                        this.removeClass('date-error');
	                        $('<?php echo $formid; ?>').fireEvent('submit');
	                    }
	                    else{
	                        this.addClass('date-error');
	                    }
	                }
	            }
	            else{
	                $('<?php echo $formid; ?>').fireEvent('submit');
	            }

			});
		});
		f.getElements('select').each(function(el) {
			el.addEvent('change', function(){
	            if(this.id == 'dtrange' && this.value == 'range'){
	                var sDate = $('sjk2filter<?php echo $module->id;?>').getElement('#sdate_<?php echo $module->id; ?>');
	                var eDate = $('sjk2filter<?php echo $module->id;?>').getElement('#edate_<?php echo $module->id; ?>');
	                if(sDate.get('value') != '' && eDate.get('value') != ''){
	                    var isStartDate = isDate(sDate.get('value'));
	                    var isEndDate = isDate(eDate.get('value'));
	                    if(isStartDate && isEndDate){
	                        $('<?php echo $formid; ?>').fireEvent('submit');
	                    }
	                    else{
	                        if(!isStartDate)
	                            sDate.addClass('date-error');
	                        if(!isEndDate)
	                            eDate.addClass('date-error');
	                    }
	                }
	            }
	            else{
	                $('<?php echo $formid; ?>').fireEvent('submit');
	            }
			});
		});
		f.getElements('textarea').each(function(el) {
			el.addEvent('change', function(){
				$('<?php echo $formid; ?>').fireEvent('submit');
			});
		});
	<?php }?>

	<?php if($ajax_filter): ?>
		$('<?php echo $formid; ?>').addEvent('submit', function() {
			sjk2AjaxSubmit(this, '<?php echo JURI::root(true).'/'; ?>');
			return false;
		});
		jQuery('#<?php echo $formid; ?>').on('submit', function(event) {
			event.preventDefault();
			sjk2AjaxSubmit(this, '<?php echo JURI::root(true).'/'; ?>');
			return false;
		});
		if(jQuery('#k2Container')) {
			sjk2AjaxPagination(jQuery('#k2Container'), '<?php echo JURI::root(true).'/'; ?>');
		}
	<?php else: ?>
		$('<?php echo $formid; ?>').addEvent('submit', function() {
			$('<?php echo $formid; ?>').submit();
		});
	<?php endif; ?>
});
/*]]>*/
</script>