<?php
/**
 * @version    2.7.x
 * @package    K2
 * @author     JoomlaWorks http://www.joomlaworks.net
 * @copyright  Copyright (c) 2006 - 2016 JoomlaWorks Ltd. All rights reserved.
 * @license    GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 */

// no direct access
defined('_JEXEC') or die;

?>

<?php if(JRequest::getInt('print')==1): ?>
<!-- Print button at the top of the print page only -->
<a class="itemPrintThisPage" rel="nofollow" href="#" onclick="window.print();return false;">
	<span><?php echo JText::_('K2_PRINT_THIS_PAGE'); ?></span>
</a>
<?php endif; ?>

<!-- Start K2 Item Layout -->
<span id="startOfPageId<?php echo JRequest::getInt('id'); ?>"></span>

<div id="k2Container" class="itemView<?php echo ($this->item->featured) ? ' itemIsFeatured' : ''; ?><?php if($this->item->params->get('pageclass_sfx')) echo ' '.$this->item->params->get('pageclass_sfx'); ?>">

	<!-- Plugins: BeforeDisplay -->
	<?php echo $this->item->event->BeforeDisplay; ?>

	<!-- K2 Plugins: K2BeforeDisplay -->
	<?php echo $this->item->event->K2BeforeDisplay; ?>


	<!-- Plugins: AfterDisplayTitle -->
	<?php echo $this->item->event->AfterDisplayTitle; ?>

	<!-- K2 Plugins: K2AfterDisplayTitle -->
	<?php echo $this->item->event->K2AfterDisplayTitle; ?>
	<div class="itemBody">

		<!-- Plugins: BeforeDisplayContent -->
		<?php echo $this->item->event->BeforeDisplayContent; ?>

		<!-- K2 Plugins: K2BeforeDisplayContent -->
		<?php echo $this->item->event->K2BeforeDisplayContent; ?>

		<?php if($this->item->params->get('itemImage')): ?>
		<!-- Item Image -->
		<div class="itemImageBlock">
			<div class="itemImage">
			<?php 
			   //Create placeholder items images
		   
			   $src = $this->item->image;
			   if (!empty( $src)) {								
				   $thumb_img = '<img src="'.$src.'" alt="'.$this->item->title.'" />';
			   } else if ($is_placehold) {					
				   $thumb_img = yt_placehold($placehold_size['k2_item'],$this->item->title,$this->item->title);
			   }	
			   echo $thumb_img;
		   ?>
			</div>
			<div class="content-intro">
				<div class="itemHeader">
					<?php if($this->item->params->get('itemRating')): ?>
					<!-- Item Rating -->
					<div class="itemRatingBlock">
						<div class="itemRatingForm">
							<ul class="itemRatingList">
								<li class="itemCurrentRating" id="itemCurrentRating<?php echo $this->item->id; ?>" style="width:<?php echo $this->item->votingPercentage; ?>%;"></li>
								<li><a href="#" data-id="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_1_STAR_OUT_OF_5'); ?>" class="one-star">1</a></li>
								<li><a href="#" data-id="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_2_STARS_OUT_OF_5'); ?>" class="two-stars">2</a></li>
								<li><a href="#" data-id="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_3_STARS_OUT_OF_5'); ?>" class="three-stars">3</a></li>
								<li><a href="#" data-id="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_4_STARS_OUT_OF_5'); ?>" class="four-stars">4</a></li>
								<li><a href="#" data-id="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_5_STARS_OUT_OF_5'); ?>" class="five-stars">5</a></li>
							</ul>
							<div id="itemRatingLog<?php echo $this->item->id; ?>" class="itemRatingLog"><?php echo $this->item->numOfvotes; ?></div>
							<div class="clr"></div>
						</div>
						<div class="clr"></div>
					</div>
					<?php endif; ?>
				
					<?php if($this->item->params->get('itemTitle')): ?>
					<!-- Item title -->
					<h2 class="itemTitle">
						<?php if(isset($this->item->editLink)): ?>
						<!-- Item edit link -->
						<span class="itemEditLink">
							<a data-k2-modal="edit" href="<?php echo $this->item->editLink; ?>"><?php echo JText::_('K2_EDIT_ITEM'); ?></a>
						</span>
						<?php endif; ?>
				
						<?php echo $this->item->title; ?>
				
						<?php if($this->item->params->get('itemFeaturedNotice') && $this->item->featured): ?>
						<!-- Featured flag -->
						<span>
							<sup>
								<?php echo JText::_('K2_FEATURED'); ?>
							</sup>
						</span>
						<?php endif; ?>
					</h2>
					<?php endif; ?>
				
					 
					<?php if($this->item->params->get('catItemExtraFields') && count($this->item->extra_fields)): ?>
					<div class="coursefees">
							<?php foreach ($this->item->extra_fields as $key=>$extraField): ?>
							<?php if(($extraField->value != '')&&($extraField->alias=="coursefees")): ?>
								<?php echo $extraField->value; ?>
							<?php endif; ?>
							<?php endforeach; ?>
					</div>
					<?php endif; ?>
				</div>
				<?php if($this->item->params->get('catItemExtraFields') && count($this->item->extra_fields)): ?>
				<div class="specialization">
						<?php foreach ($this->item->extra_fields as $key=>$extraField): ?>
						<?php if(($extraField->value != '')&&($extraField->alias=="department")): ?>
							<span><?php echo JText::_('SPECIALIZATION').' : '; ?> </span><?php echo $extraField->value; ?>
						<?php endif; ?>
						<?php endforeach; ?>
				</div>
				<?php endif; ?>
				<?php if($this->item->params->get('catItemExtraFields') && count($this->item->extra_fields)): ?>
				<ul class="list-extra">
					  <?php foreach ($this->item->extra_fields as $key=>$extraField): ?>
					  <?php if(($extraField->value != '')&&($extraField->alias=="duration")): ?>
						  <li class="duration"><span><?php echo JText::_('DURATIONS').' : '; ?> </span><?php echo $extraField->value; ?></li>
					  <?php endif; ?>
					  <?php endforeach; ?>
					  <?php foreach ($this->item->extra_fields as $key=>$extraField): ?>
					  <?php if(($extraField->value != '')&&($extraField->alias=="Numberofstudent")): ?>
						  <li class="number"><span><?php echo JText::_('STUDENTS').' : '; ?></span><?php echo $extraField->value; ?></li>
					  <?php endif; ?>
					  <?php endforeach; ?>
				</ul>
				<?php endif; ?>
				<?php if($this->item->params->get('catItemExtraFields') && count($this->item->extra_fields)): ?>
				<div class="courseslink">
						<?php foreach ($this->item->extra_fields as $key=>$extraField): ?>
						<?php if(($extraField->value != '')&&($extraField->alias=="Levelcourses")): ?>
							<?php echo $extraField->value; ?>
						<?php endif; ?>
						<?php endforeach; ?>
				</div>
				<?php endif; ?>
				
			</div>
			<div class="clr"></div>
		</div>
		<?php endif; ?>

		<?php if(!empty($this->item->fulltext)): ?>

		<?php if($this->item->params->get('itemIntroText')): ?>
		<!-- Item introtext -->
		<div class="itemIntroText">
			<?php echo $this->item->introtext; ?>
		</div>
		<?php endif; ?>

		<?php if($this->item->params->get('itemFullText')): ?>
		<!-- Item fulltext -->
		<div class="itemFullText">
			<?php echo $this->item->fulltext; ?>
		</div>
		<?php endif; ?>

		<?php else: ?>

		<!-- Item text -->
		<div class="itemFullText">
			<?php echo $this->item->introtext; ?>
		</div>

		<?php endif; ?>

		<div class="clr"></div>
		<?php if($this->item->params->get('itemHits') || ($this->item->params->get('itemDateModified') && intval($this->item->modified)!=0)): ?>
		<div class="itemContentFooter">

			<?php if($this->item->params->get('itemHits')): ?>
			<!-- Item Hits -->
			<span class="itemHits">
				<?php echo JText::_('K2_READ'); ?> <b><?php echo $this->item->hits; ?></b> <?php echo JText::_('K2_TIMES'); ?>
			</span>
			<?php endif; ?>

			<?php if($this->item->params->get('itemDateModified') && intval($this->item->modified)!=0): ?>
			<!-- Item date modified -->
			<span class="itemDateModified">
				<?php echo JText::_('K2_LAST_MODIFIED_ON'); ?> <?php echo JHTML::_('date', $this->item->modified, JText::_('K2_DATE_FORMAT_LC2')); ?>
			</span>
			<?php endif; ?>

			<div class="clr"></div>
		</div>
		<?php endif; ?>

		<!-- Plugins: AfterDisplayContent -->
		<?php echo $this->item->event->AfterDisplayContent; ?>

		<!-- K2 Plugins: K2AfterDisplayContent -->
		<?php echo $this->item->event->K2AfterDisplayContent; ?>

		<div class="clr"></div>

	</div>

	

	<?php if(
		$this->item->params->get('itemCategory') ||
		$this->item->params->get('itemAttachments')
	): ?>
	<div class="itemLinks">

		<?php if($this->item->params->get('itemCategory')): ?>
		<!-- Item category -->
		<div class="itemCategory">
			<span><?php echo JText::_('K2_PUBLISHED_IN'); ?></span>
			<a href="<?php echo $this->item->category->link; ?>"><?php echo $this->item->category->name; ?></a>
		</div>
		<?php endif; ?>

		

		<?php if($this->item->params->get('itemAttachments') && count($this->item->attachments)): ?>
		<!-- Item attachments -->
		<div class="itemAttachmentsBlock">
			<span><?php echo JText::_('K2_DOWNLOAD_ATTACHMENTS'); ?></span>
			<ul class="itemAttachments">
				<?php foreach ($this->item->attachments as $attachment): ?>
				<li>
					<a title="<?php echo K2HelperUtilities::cleanHtml($attachment->titleAttribute); ?>" href="<?php echo $attachment->link; ?>"><?php echo $attachment->title; ?></a>
					<?php if($this->item->params->get('itemAttachmentsCounter')): ?>
					<span>(<?php echo $attachment->hits; ?> <?php echo ($attachment->hits==1) ? JText::_('K2_DOWNLOAD') : JText::_('K2_DOWNLOADS'); ?>)</span>
					<?php endif; ?>
				</li>
				<?php endforeach; ?>
			</ul>
		</div>
		<?php endif; ?>

		<div class="clr"></div>
	</div>
	<?php endif; ?>

	<?php if($this->item->params->get('itemAuthorBlock') && empty($this->item->created_by_alias)): ?>
	<!-- Author Block -->
	<div class="itemAuthorBlock">
		<?php if($this->item->params->get('itemAuthorImage') && !empty($this->item->author->avatar)): ?>
		<img class="itemAuthorAvatar" src="<?php echo $this->item->author->avatar; ?>" alt="<?php echo K2HelperUtilities::cleanHtml($this->item->author->name); ?>" />
		<?php endif; ?>

		<div class="itemAuthorDetails">
			<h3 class="itemAuthorName">
				<a rel="author" href="<?php echo $this->item->author->link; ?>"><?php echo $this->item->author->name; ?></a>
			</h3>

			<?php if($this->item->params->get('itemAuthorDescription') && !empty($this->item->author->profile->description)): ?>
			<p><?php echo $this->item->author->profile->description; ?></p>
			<?php endif; ?>

			<?php if($this->item->params->get('itemAuthorURL') && !empty($this->item->author->profile->url)): ?>
			<span class="itemAuthorUrl"><i class="k2icon-globe"></i> <a rel="me" href="<?php echo $this->item->author->profile->url; ?>" target="_blank"><?php echo str_replace('http://','',$this->item->author->profile->url); ?></a></span>
			<?php endif; ?>
			
			<?php if($this->item->params->get('itemAuthorURL') && !empty($this->item->author->profile->url) && $this->item->params->get('itemAuthorEmail')): ?>
			<span class="k2HorizontalSep">|</span>
			<?php endif; ?>
			
			<?php if($this->item->params->get('itemAuthorEmail')): ?>
			<span class="itemAuthorEmail"><i class="k2icon-envelope"></i> <?php echo JHTML::_('Email.cloak', $this->item->author->email); ?></span>
			<?php endif; ?>

			<div class="clr"></div>

			<!-- K2 Plugins: K2UserDisplay -->
			<?php echo $this->item->event->K2UserDisplay; ?>

			<div class="clr"></div>
		</div>
		<div class="clr"></div>
	</div>
	<?php endif; ?>

	<?php if($this->item->params->get('itemAuthorLatest') && empty($this->item->created_by_alias) && isset($this->authorLatestItems)): ?>
	<!-- Latest items from author -->
	<div class="itemAuthorLatest">
		<h3><?php echo JText::_('K2_LATEST_FROM'); ?> <?php echo $this->item->author->name; ?></h3>
		<ul>
			<?php foreach($this->authorLatestItems as $key=>$item): ?>
			<li class="<?php echo ($key%2) ? "odd" : "even"; ?>">
				<a href="<?php echo $item->link ?>"><?php echo $item->title; ?></a>
			</li>
			<?php endforeach; ?>
		</ul>
		<div class="clr"></div>
	</div>
	<?php endif; ?>

	<?php
	/*
	A note regarding 'Related Items'...
	If you add:
	- the CSS rule 'overflow-x:scroll;' in the element div.itemRelated {…} in the k2.css
	- the class 'k2Scroller' to the ul element below
	- the classes 'k2ScrollerElement' and 'k2EqualHeights' to the li element inside the foreach loop below
	- the style attribute 'style="width:<?php echo $item->imageWidth; ?>px;"' to the li element inside the foreach loop below
	...then your Related Items will be transformed into a vertical-scrolling block, inside which, all items have the same height (equal column heights). This can be very useful if you want to show your related articles or products with title/author/category/image etc., which would take a significant amount of space in the classic list-style display.
	*/
	?>

	

	<?php if($this->item->params->get('itemVideo') && !empty($this->item->video)): ?>
	<!-- Item video -->
	<a name="itemVideoAnchor" id="itemVideoAnchor"></a>
	<div class="itemVideoBlock">
		<h3><?php echo JText::_('K2_MEDIA'); ?></h3>

		<?php if($this->item->videoType=='embedded'): ?>
		<div class="itemVideoEmbedded">
			<?php echo $this->item->video; ?>
		</div>
		<?php else: ?>
		<span class="itemVideo"><?php echo $this->item->video; ?></span>
		<?php endif; ?>

		<?php if($this->item->params->get('itemVideoCaption') && !empty($this->item->video_caption)): ?>
		<span class="itemVideoCaption"><?php echo $this->item->video_caption; ?></span>
		<?php endif; ?>

		<?php if($this->item->params->get('itemVideoCredits') && !empty($this->item->video_credits)): ?>
		<span class="itemVideoCredits"><?php echo $this->item->video_credits; ?></span>
		<?php endif; ?>

		<div class="clr"></div>
	</div>
	<?php endif; ?>

	<?php if($this->item->params->get('itemImageGallery') && !empty($this->item->gallery)): ?>
	<!-- Item image gallery -->
	<a name="itemImageGalleryAnchor" id="itemImageGalleryAnchor"></a>
	<div class="itemImageGallery">
		<h3><?php echo JText::_('K2_IMAGE_GALLERY'); ?></h3>
		<?php echo $this->item->gallery; ?>
	</div>
	<?php endif; ?>

	<?php if($this->item->params->get('itemNavigation') && !JRequest::getCmd('print') && (isset($this->item->nextLink) || isset($this->item->previousLink))): ?>
	<!-- Item navigation -->
	<div class="itemNavigation">
		<span class="itemNavigationTitle"><?php echo JText::_('K2_MORE_IN_THIS_CATEGORY'); ?></span>

		<?php if(isset($this->item->previousLink)): ?>
		<a class="itemPrevious" href="<?php echo $this->item->previousLink; ?>">&laquo; <?php echo $this->item->previousTitle; ?></a>
		<?php endif; ?>

		<?php if(isset($this->item->nextLink)): ?>
		<a class="itemNext" href="<?php echo $this->item->nextLink; ?>"><?php echo $this->item->nextTitle; ?> &raquo;</a>
		<?php endif; ?>
	</div>
	<?php endif; ?>

	<!-- Plugins: AfterDisplay -->
	<?php echo $this->item->event->AfterDisplay; ?>

	<!-- K2 Plugins: K2AfterDisplay -->
	<?php echo $this->item->event->K2AfterDisplay; ?>

	<?php if(
		$this->item->params->get('itemComments') &&
		(($this->item->params->get('comments') == '2' && !$this->user->guest) || ($this->item->params->get('comments') == '1'))
	): ?>
	<!-- K2 Plugins: K2CommentsBlock -->
	<?php echo $this->item->event->K2CommentsBlock; ?>
	<?php endif; ?>

	<?php if(
		$this->item->params->get('itemComments') &&
		($this->item->params->get('comments') == '1' || ($this->item->params->get('comments') == '2')) && empty($this->item->event->K2CommentsBlock)
	): ?>
	<!-- Item comments 2-->
	<div id="fb-root"></div> 
    <script>(function(d, s, id) { 
            var js, fjs = d.getElementsByTagName(s)[0]; 
            if (d.getElementById(id)) return; 
            js = d.createElement(s); js.id = id; 
            js.src = "//connect.facebook.net/en_US/all.js#xfbml=1"; 
            fjs.parentNode.insertBefore(js, fjs); 
            }(document, 'script', 'facebook-jssdk'));
    </script> 

    <div class="fb-comments" data-href="<?php $url="".$this->item->absoluteURL; echo $url; ?>" data-width="100%" data-num-posts="10"></div> 
	
	<?php endif; ?>

	<?php if($this->item->params->get('itemRelated') && isset($this->relatedItems)): ?>
	<!-- Related items by tag -->
	<div class="itemRelated">
		<h3><?php echo JText::_("YOU_ALSO_CAN_SEE"); ?></h3>
		<div class="slider-related">
			<?php foreach($this->relatedItems as $key=>$item): ?>
			<div class="catItemBody">
				<div class="item">
					<div class="catItemImageBlock">
						<div class="catItemImage">
								<?php if($this->item->params->get('itemRelatedImageSize')): ?>
								<a class="itemRelTitle" href="<?php echo $item->link ?>">
									<img  class="itemRelImg" src="<?php echo $item->image; ?>" alt="<?php echo K2HelperUtilities::cleanHtml($item->title); ?>" />
								</a>
								<?php endif; ?>
							  <?php if($this->item->params->get('itemExtraFields') && count($this->item->extra_fields)): ?>
							   
								  <?php foreach ($this->item->extra_fields as $key=>$extraField): ?>
								  <?php if(($extraField->value != '')&&($extraField->alias=="IMDb")): ?>
									  <span class="imdb"><?php echo $extraField->value; ?></span>
								  <?php endif; ?>
								  <?php endforeach; ?>
							  <?php endif; ?>
							  <?php if($this->item->params->get('itemExtraFields') && count($this->item->extra_fields)): ?>
							   
								  <?php foreach ($this->item->extra_fields as $key=>$extraField): ?>
								  <?php if(($extraField->value != '') && ($extraField->alias=="Lable")): ?>
									  <span class="label"><?php echo $extraField->value; ?></span>
								  <?php endif; ?>
								  <?php endforeach; ?>
							  <?php endif; ?>
							  <?php if($this->item->params->get('itemExtraFields') && count($this->item->extra_fields)): ?>
							   
							  <?php foreach ($this->item->extra_fields as $key=>$extraField): ?>
							  <?php if(($extraField->value != '')&&($extraField->alias=="ViewTrailer")): ?>
									<div class="link-trailer">
										  <a href="<?php echo $extraField->value; ?>" data-rel="prettyPhoto" title="">
												<?php echo JText::_('VIEW_TRAILER');?>
										  </a>
									</div>
							  <?php endif; ?>
							  <?php endforeach; ?>
							 <?php endif; ?>
						</div>
					</div>
					<?php if($this->item->params->get('itemRelatedTitle', 1)): ?>
					<div class="catItemHeader">
						<h3 class="catItemTitle font-title">
								<a class="itemRelTitle" href="<?php echo $item->link ?>"><?php echo $item->title; ?></a>
						</h3>
					</div>
					<?php endif; ?>
					<?php if($this->item->params->get('catItemRating')): ?>
					<!-- Item Rating -->
					<div class="itemRatingBlock">
						<div class="itemRatingForm">
							<ul class="itemRatingList">
								<li class="itemCurrentRating" id="itemCurrentRating<?php echo $this->item->id; ?>" style="width:<?php echo $this->item->votingPercentage; ?>%;"></li>
								<li><a href="#" data-id="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_1_STAR_OUT_OF_5'); ?>" class="one-star">1</a></li>
								<li><a href="#" data-id="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_2_STARS_OUT_OF_5'); ?>" class="two-stars">2</a></li>
								<li><a href="#" data-id="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_3_STARS_OUT_OF_5'); ?>" class="three-stars">3</a></li>
								<li><a href="#" data-id="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_4_STARS_OUT_OF_5'); ?>" class="four-stars">4</a></li>
								<li><a href="#" data-id="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_5_STARS_OUT_OF_5'); ?>" class="five-stars">5</a></li>
							</ul>
							<div id="itemRatingLog<?php echo $this->item->id; ?>" class="itemRatingLog"><?php echo $this->item->numOfvotes; ?></div>
						</div>
					</div>
					<?php endif; ?>
					<div class="type-duration">
						<?php if($this->item->params->get('itemExtraFields') && count($this->item->extra_fields)): ?>
						 
							<?php foreach ($this->item->extra_fields as $key=>$extraField): ?>
							<?php if(($extraField->value != '')&&($extraField->alias=="Type")): ?>
								<span class="type"><?php echo $extraField->value; ?></span>
							<?php endif; ?>
							<?php endforeach; ?>
							<?php foreach ($this->item->extra_fields as $key=>$extraField): ?>
							<?php if(($extraField->value != '')&&($extraField->alias=="MovieDuration")): ?>
								<span class="duration"><?php echo $extraField->value; ?></span>
							<?php endif; ?>
							<?php endforeach; ?>
						<?php endif; ?>
					</div>
					<?php if($this->item->params->get('itemRelatedAuthor')): ?>
					<div class="itemRelAuthor"><?php echo JText::_("K2_BY"); ?> <a rel="author" href="<?php echo $item->author->link; ?>"><?php echo $item->author->name; ?></a></div>
					<?php endif; ?>

					<?php if($this->item->params->get('itemRelatedIntrotext')): ?>
					<div class="itemRelIntrotext"><?php echo $item->introtext; ?></div>
					<?php endif; ?>
	
					<?php if($this->item->params->get('itemRelatedFulltext')): ?>
					<div class="itemRelFulltext"><?php echo $item->fulltext; ?></div>
					<?php endif; ?>
	
					<?php if($this->item->params->get('itemRelatedMedia')): ?>
					<?php if($item->videoType=='embedded'): ?>
					<div class="itemRelMediaEmbedded"><?php echo $item->video; ?></div>
					<?php else: ?>
					<div class="itemRelMedia"><?php echo $item->video; ?></div>
					<?php endif; ?>
					<?php endif; ?>
	
					<?php if($this->item->params->get('itemRelatedImageGallery')): ?>
					<div class="itemRelImageGallery"><?php echo $item->gallery; ?></div>
					<?php endif; ?>
				</div>
			</div>
			<?php endforeach; ?>
		</div>
	</div>
	<?php endif; ?>
	

</div>
<!-- End K2 Item Layout -->
