<?php
/*
 * @package Sj K2 Filter
 * @version 1.1.0
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @copyright (c) 2016 YouTech Company. All Rights Reserved.
 * @author YouTech Company http://www.smartaddons.com
 *
 */

// no direct access
defined('_JEXEC') or die ('Restricted access');

// Load the K2 Plugin API
JLoader::register('K2Plugin', JPATH_ADMINISTRATOR.DS.'components'.DS.'com_k2'.DS.'lib'.DS.'k2plugin.php');

// Initiate class to hold plugin events
class plgK2Sjk2filter extends K2Plugin {

	// Some params
	var $pluginName = 'sjk2filter';
	var $pluginNameHumanReadable = 'K2 - Plugin Sj K2 Filter';

	function plgK2Sjk2filter( & $subject, $params) {
		parent::__construct($subject, $params);
	}

	public function onAfterK2Save(&$row, $isNew) {
		$this->indexingData($row, $isNew);
	}
	
	private function indexingData($row, $isNew) {
		$db = JFactory::getDbo();
        $jnow = JFactory::getDate();
        $now = K2_JVERSION == '15' ? $jnow->toMySQL() : $jnow->toSql();
        $nullDate = $db->getNullDate();

		$updateid = $row->id;
		$updateCatid = $row->catid;
		$updateAuthor = $row->created_by;
		$updateFields = json_decode($row->extra_fields);
		$updateTags = $this->getItemTags($row->id);
		$language = $row->language;

		$aXFSupported = array('select', 'multipleSelect', 'radio', 'labels', 'textfield', 'date');
		$query = "SELECT `id`, `name`, `value` FROM #__k2_extra_fields WHERE `type` IN ('".implode("','", $aXFSupported). "')";
		$db->setQuery($query);
		$aXFSupported = $db->loadObjectList('id');

		$query = 'SELECT id FROM #__k2_extra_fields WHERE `type` = '.$db->quote('labels');
		$db->setQuery($query);
		$aLabels = $db->loadColumn();

		$query = "SELECT `id` FROM #__k2_extra_fields WHERE `type` IN (".$db->quote('textfield').",".$db->quote('date').")";
		$db->setQuery($query);
		$aTextfields = $db->loadColumn();

		$query = "DELETE FROM #__sjk2filter_taxonomy_map WHERE item_id = ".$db->quote($updateid);
		$db->setQuery($query);
		$db->execute();
		
		$query = "SELECT `id`, `name` FROM #__k2_categories WHERE `id`=".$db->quote($updateCatid);
		$db->setQuery($query);
		$cat = $db->loadObject();
		if($cat) {
			$this->addNodeMap('category', $updateCatid, 0, $updateid, $cat->name, $language);
		}
		
		$query = "SELECT `id`, `name` FROM #__users WHERE `id` = ".$db->quote($updateAuthor);
		$db->setQuery($query);
		$author = $db->loadObject();
		if($author) {
			$this->addNodeMap('author', $updateAuthor, 0, $updateid, $author->name, $language);
		}
		
		if(is_array($updateFields)) {
			foreach ($updateFields as $f) {
				if(!isset($aXFSupported[$f->id])) continue;

				if(is_array($f->value)) {
					foreach ($f->value as $sf) {
						$label = $this->getOptionName($aXFSupported[$f->id], $sf);
						$this->addNodeMap('xfield', $f->id, $sf, $updateid, $label, $language);
					}
				} else {
					if(in_array($f->id, $aLabels) || in_array($f->id, $aTextfields)) {
						if(in_array($f->id, $aLabels)) {
							$labels = explode(',', $f->value);
						} else {
							$labels = array($f->value);
						}

						if(count($labels)) {
							foreach($labels as $label) {
								$label = trim($label);
								if(empty($label)) continue;
								$this->addNodeMap('xfield', $f->id, 0, $updateid, $label, $language);
							}
						}
					} else {
						$label = $this->getOptionName($aXFSupported[$f->id], $f->value);
						$this->addNodeMap('xfield', $f->id, $f->value, $updateid, $label, $language);
					}
				}
			}
		}

		//tags
		if(is_array($updateTags) && count($updateTags)) {
			foreach ($updateTags as $t) {
				$this->addNodeMap('tag', $t->id, 0, $updateid, $t->name, $language);
			}
		}

		//UPDATE COUNTER
		$query = "
				UPDATE #__sjk2filter_taxonomy
				SET num_items = (
					SELECT COUNT(item_id) FROM #__sjk2filter_taxonomy_map
					WHERE #__sjk2filter_taxonomy_map.node_id = #__sjk2filter_taxonomy.id
				)";
		$query;
		$db->setQuery($query);
		$db->execute();

		$now = date('Y-m-d H:i:s');
		$query = "
				INSERT INTO #__sjk2filter
				SET 
					`name` = 'cron',
					`updatetime` = ".$db->quote($now).",
					`value` = 1
				ON DUPLICATE KEY UPDATE
					`updatetime` = ".$db->quote($now).",
					`value` = 1
				";
		$db->setQuery($query);
		$db->execute();
	}

	public function getOptionName($field, $option_id) {
		$xfields = json_decode($field->value);
		if(count($xfields)) {
			foreach ($xfields as $xfield) {
				if($xfield->value == $option_id) {
					return $xfield->name;
				}
			}
		}
		return '';
	}
	
	private function addNodeMap($type, $asset_id, $option_id, $item_id, $label='', $language = '*') {
		$db = JFactory::getDbo();
		$byLabel = false;
		if($type == 'xfield' && !$option_id) {
			$byLabel = true;
		}
		$query = "SELECT id FROM #__sjk2filter_taxonomy
			WHERE `type` = ".$db->quote($type)
			." AND asset_id = ".$db->quote($asset_id);
		if($byLabel) {
			$query .= " AND labels = ".$db->quote($label);
		} else {
			$query .= " AND option_id = ".$db->quote($option_id);
		}
		$db->setQuery($query);
		
		$nodeid = $db->loadResult();
		if(!$nodeid) {
			$title = $type;
			
			$query = $db->getQuery(true);
			$query->insert('#__sjk2filter_taxonomy');
			$query->columns(array($db->quoteName('type'), $db->quoteName('title'), $db->quoteName('asset_id'), $db->quoteName('option_id'), $db->quoteName('labels'), $db->quoteName('num_items')));
			$query->values($db->quote($type) . ', ' . $db->quote($title). ', ' . $db->quote($asset_id). ', ' . $db->quote($option_id). ', ' . $db->quote($label). ', ' . $db->quote(0));			
			$db->setQuery($query);
			$db->execute();
			$nodeid = $db->insertid();
		} else {
			if(!$byLabel && !empty($label)) {
				$query = $db->getQuery(true);
				$query->update('#__sjk2filter_taxonomy')
					->set($db->quoteName('labels') .'='.$db->quote($label))
					->where($db->quoteName('id').'='.$db->quote($nodeid));
				$db->setQuery($query);
				$db->execute();
			}
		}
		
		if($nodeid) {
			$db = JFactory::getDbo();
			$query = "INSERT INTO #__sjk2filter_taxonomy_map (`node_id`, `item_id`, `language`) VALUES( ".$db->quote($nodeid).", ".$db->quote($item_id).", ".$db->quote($language).")";
			$db->setQuery($query);
			$db->execute();
		}	
	}
	
	private function getItemTags($itemID)
	{
		$db = JFactory::getDBO();

		$query = "SELECT tag.id, tag.`name`
		FROM #__k2_tags AS tag
		JOIN #__k2_tags_xref AS xref ON tag.id = xref.tagID
		WHERE tag.published=1
		AND xref.itemID = ".(int)$itemID." ORDER BY xref.id ASC";

		$db->setQuery($query);
		$rows = $db->loadObjectList();
		
		return $rows;
	}
}