<?php
/*
 * @package Sj K2 Filter
 * @version 1.1.0
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @copyright (c) 2016 YouTech Company. All Rights Reserved.
 * @author YouTech Company http://www.smartaddons.com
 *
 */

defined('_JEXEC') or die( 'Restricted access' );

class JFormFieldSjdepend extends JFormField
{
	protected $type = 'Sjdepend';
	
	function loadAsset(){
		if (!defined ('_SJ_DEPEND_ASSET_')) {
			define ('_SJ_DEPEND_ASSET_', 1);
			$uri = str_replace(DIRECTORY_SEPARATOR, '/', str_replace( JPATH_SITE, JURI::base(), dirname(__FILE__) ));
			$uri = str_replace('/administrator/', '', $uri);
			
			//mootools support joomla 1.7 and 2.5
			JHTML::_('behavior.framework', true);
			
			JHTML::stylesheet($uri.'/assets/css/sjdepend.css');
			if(version_compare(JVERSION, '3.0', 'ge')) {
				JHTML::stylesheet($uri.'/assets/css/sjdepend_3x.css');
			}
			JHTML::script($uri.'/assets/js/sjdepend.js');
			JHTML::script($uri.'/assets/js/sjk2extrafield.js');
		}
	}

	protected function getInput(){
		$this->loadAsset();
		
		$func 	= (string)$this->element['function'] ? (string)$this->element['function'] : '';
		$value 	= $this->value ? $this->value : (string) $this->element['default'];

		if (substr($func, 0, 1) == '@'){
			$func = substr($func, 1);
			if (method_exists($this, $func)) {
				return $this->$func();
			}
		} else {
			$subtype = ( isset( $this->element['subtype'] ) ) ? trim($this->element['subtype']) : '';
			if (method_exists ($this, $subtype)) {
				return $this->$subtype ();
			}
		}

		return null;
	}
	
    function getLabel()
    {
    	$func 	= (string)$this->element['function']?(string)$this->element['function']:'';
    	if (substr($func, 0, 1) == '@' || !isset( $this->label ) || !$this->label){
    		return;
    	} else {
    		return parent::getLabel ();
    	}
    }

	function title()
	{
		$_title = (string) $this->element['label'];
		$_description = $this->description;
		$_url = (isset($this->element['url'])) ? (string) $this->element['url'] : '';
		$class = (isset($this->element['class'])) ? (string) $this->element['class'] : '';
		$level = (isset($this->element['level'])) ? (string) $this->element['level'] : '';
		$group = (isset($this->element['group'])) ? (string) $this->element['group'] : '';
		$group = $group ? "id='params$group-group'" : "";
		if ($_title) {
			$_title = html_entity_decode(JText::_($_title));
		}

		if ($_description) {
			$_description = html_entity_decode(JText::_($_description));
		}
		if ($_url) {
			$_url = " <a target='_blank' href='{$_url}' >[" . html_entity_decode(JText::_("Demo")) . "]</a> ";
		}
		
		$regionID = time()+rand();
		
		$class_name = trim(str_replace(" ", "", strtolower($_title) ));
		
		if($level==1){
			$html = '
			<h4 rel="'.$level.'" class="block-head block-head-'.$class_name.' open '.$class.' " '.$group.' id="'.$regionID.'">
			<span class="block-setting" >'.$_title.$_url.'</span> 
			<span class="icon-help editlinktip hasTip" title="'.htmlentities($_description).'">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>
			<a class="toggle-btn open" title="'.JText::_('Expand all').'" onclick="SJDepend.inst.showseg(\''.$regionID.'\', \'level'.$level.'\'); return false;">'.JText::_('Expand all').'</a>
			<a class="toggle-btn close" title="'.JText::_('Collapse all').'" onclick="SJDepend.inst.showseg(\''.$regionID.'\', \'level'.$level.'\'); return false;">'.JText::_('Collapse all').'</a>
			</h4>';
		} else {
			$html = '
			<h4 rel="'.$level.'" class="block-head block-head-'.$class_name.' open '.$class.' " '.$group.' id="'.$regionID.'">
			<span class="block-setting" >'.$_title.$_url.'</span> 
			<span class="icon-help editlinktip hasTip" title="'.htmlentities($_description).'">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>
			<a class="toggle-btn" title="'.JText::_('Click here to expand or collapse').'" onclick="SJDepend.inst.segment(\''.$regionID.'\', \'level'.$level.'\'); return false;">open</a>
			</h4>';
		} 
		//<div class="block-des '.$class.'"  id="desc-'.$regionID.'">'.$_description.'</div>';
		
		return $html;
	}
	
	function checkbox(){		
		$k = 0;
		$html = "";
		
		$cols = intval($this->element['cols']);
		if($cols == 0){
			$cols = 1;
		}
		$width = floor(100/$cols);
		$style = ' style="width:'.$width.'%;"';
		if($this->element->children()){
			foreach ($this->element->children() as $option)
			{
				$group = isset($option['group'])?intval($option['group']):0;
				$odesc	= isset($option['description'])?JText::_($option['description']):'';
				$otext	= JText::_(trim((string) $option));

				$tooltip	= addslashes(htmlspecialchars($odesc, ENT_QUOTES, 'UTF-8'));
				$titletip		= addslashes(htmlspecialchars($otext, ENT_QUOTES, 'UTF-8'));

				if($titletip) {
					$titletip = $titletip.'::';
				}
				
				if($group) {
					$html .= "\n\t<div class=\"group_title\"><span class=\"hasTip\" title=\"{$titletip}{$tooltip}\">$otext</span></div>";
				} else {

					
					$oval	= $option['value'];
					$children	= $option['children'];
					$alt = ($children) ? ' alt="'.$children.'"' : '';
					$extra	 = '';

					if (is_array( $this->value ))
					{
						foreach ($value as $val)
						{
							$val2 = is_object( $val ) ? $val->$key : $val;
							if ($oval == $val2)
							{
								$extra .= ' checked="checked"';
								break;
							}
						}
					} else {
						$extra .= ( (string)$oval == (string)$this->value  ? ' checked="checked"' : '' );
					}
					
					$html .= "\n\t<div class=\"group_item\" $style>";	
					$html .= "\n\t<input type=\"checkbox\" name=\"{$this->name}[]\" id=\"{$this->id}{$k}\" value=\"$oval\"$extra $alt />";
					$html .= "\n\t<label id=\"{$this->id}{$k}-label\" class=\"hasTip\" title=\"{$titletip}{$tooltip}\" for=\"{$this->id}{$k}\">$otext</label>";
					$html .= "\n\t</div>";
					
					$k++;
				}
			}
		}

		return $html;
	}
	
	function group(){
		preg_match_all('/jform\\[([^\]]*)\\]/', $this->name, $matches);
		$group_name = 'jform';
		
		if(!isset($matches[1]) || empty($matches[1])){
			preg_match_all('/sjform\\[([^\]]*)\\]/', $this->name, $matches);
			$group_name = 'sjform';
		}
		
		if(isset($matches[1]) && !empty($matches[1])):

			?>
		<span class="hideanchor"></span>
		<script type="text/javascript">
		$(window).addEvent('load', function(){
			<?php 
			foreach ($this->element->children() as $option){
				$elms = preg_replace('/\s+/', '', (string)$option[0]);
				?>
				SJDepend.inst.add('<?php echo $option['for']; ?>', {
					val: '<?php echo $option['value']; ?>',
					elms: '<?php echo $elms?>',
					group: '<?php echo $group_name . '[' . @$matches[1][0] . ']'; ?>'
				});
				<?php
			}
			?>
		});
		</script>
		<?php
		endif;
	}

	function legend(){
		return '<legend class="t3legend">' . JText::_($this->element['label']) . '<small class="t3legend-desc">' . JText::_($this->element['description']) . '</small> </legend>';
	}
} 