<?php
/*
 * @package Sj K2 Filter
 * @version 1.1.0
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @copyright (c) 2016 YouTech Company. All Rights Reserved.
 * @author YouTech Company http://www.smartaddons.com
 *
 */

// no direct access
defined('_JEXEC') or die;

// Include the syndicate functions only once
require_once dirname(__FILE__).'/core/helper.php';
require_once JPATH_ROOT.'/components/com_sjk2filter/helpers/helper.php';

if( JFile::exists(JPATH_BASE.DS.'components'.DS.'com_k2'.DS.'k2.php')){
	
	//INCLUDING ASSET
	require_once(dirname(__FILE__) . '/assets/behavior.php');
	include_once(dirname(__FILE__) . '/assets/asset.php');
	
	$app	= JFactory::getApplication();
	$db = JFactory::getDbo();
	$componentParams = JComponentHelper::getParams('com_sjk2filter');
	$layout = $params->get('layout', 'default');
	$menu	= $app->getMenu();
	$active	= $menu->getActive();
	$active_id = isset($active) ? $active->id : $menu->getDefault()->id;
	$path	= isset($active) ? $active->tree : array();

	$maximum_keyword 		= (int) $componentParams->get('maximum_keyword', 20);
	$showAll				= $params->get('showAllChildren');
	$class_sfx				= htmlspecialchars($params->get('moduleclass_sfx'));
	$use_standard_fields   	= (int) $params->get('use_standard_fields', 1);
	$filter_by_extrafield	= $params->get('filter_by_extrafield', array());
	$filter_by_fieldtype 	= $params->get('filter_by_fieldtype');
	
	$exgroups = '';
	if($use_standard_fields) {
		$filter_by_keyword   	= (int) $params->get('filter_by_keyword', 1);
		$filter_by_category  	= (int) $params->get('filter_by_category', 1);
		$filter_by_author    	= (int) $params->get('filter_by_author', 1);
		$filter_by_tags		 	= (int) $params->get('filter_by_tags', 0); 
		$filter_by_rating	 	= (int) $params->get('filter_by_rating', 0);
		$search_by_date	   		= (int) $params->get('search_by_date', 0);
		$catMode	 			= (int) $params->get('catMode', 0);
	} else {
		$filter_by_keyword 	= 0;
		$filter_by_category = 0;
		$filter_by_author 	= 0;
		$filter_by_tags 	= 0;
		$filter_by_rating 	= 0;
		$catMode			= 0;
		$search_by_date 	= 0;
	}
	
	$mod_layout			= $params->get('mod_layout');
	$auto_filter		= (int) $params->get('auto_filter');
	
	$mod_column = '';
	if($mod_layout == 'horizontal-layout' && $params->get('mod_column') && $params->get('mod_column') > 0){
		$mod_column	= 'width:'.round(100/$params->get('mod_column'),2).'%;';
	}
	
	$helper = new modSjk2filterHelper($module);
	
	$list	= $helper->getList($filter_by_extrafield, $filter_by_fieldtype);
	
	//search by date
	$filter_by_daterange = '';
	if($use_standard_fields && $search_by_date)
	{
		$filter_by_daterange = $helper->getSearchDateCreate();
	}
	
	//category
	$categories = '';
	$groupcategories = $params->get('k2catsid',null);
	$filter_by_category_label = $helper->getLabel($params->get('filter_by_category_fieldtype', 'select'), 'category_id', JText::_('MOD_K2_FILTER_CATEGORY'));
	
	if($use_standard_fields) {
		if($filter_by_category){		
			$categories = $helper->getCategories($groupcategories);
		} elseif ($groupcategories) {
			$categories  = $helper->getCategories($groupcategories,true);
		}
	} else {
		if(is_array($filter_by_extrafield) && count($filter_by_extrafield)) {
			$query = "
				SELECT DISTINCT ".$db->quoteName('c.id')." 
				FROM #__k2_categories c
				INNER JOIN #__k2_extra_fields xf ON xf.group = c.extraFieldsGroup
				WHERE xf.id IN (".implode(',', $filter_by_extrafield).")";
			$db->setQuery($query);
			
			if (version_compare(JVERSION, '3.0', 'ge'))
			{
			   $cids = $db->loadColumn(0);
			}
			else
			{
			   $cids = $db->loadResultArray(0);
			}
			if(count($cids)) {
				$categories  = '<input type="hidden" name="category_id" value="'.implode(',', $cids).'" />';
			}
		}
	}

	$selected_group = 0;
	if(count($_GET)) {
		$xf = array();
		foreach($_GET as $key => $val) {
			if(preg_match('/^xf_[0-9]+$/', $key)) {
				$xf[] = (int) (str_replace('xf_', '', $key));
			}
		}
		if(count($xf)) {
			$query = "SELECT `group` FROM #__k2_extra_fields WHERE `id` IN (".implode(',', $xf).") ORDER BY `group` DESC";
			$db->setQuery($query);
			$selected_group = $db->loadResult();
		}
	}

	//author
	$authors = '';
	if($use_standard_fields && $filter_by_author){
		$filter_author_display = $params->get('filter_author_display','author_display_name');
		$authors = $helper->getAuthors($filter_author_display);
		$authors_label = $helper->getLabel($params->get('filter_by_author_fieldtype', 'select'), 'created_by', JText::_('MOD_K2_FILTER_AUTHOR'));
	}
	
	//tags
	$filter_by_tags_display = '';
	if($use_standard_fields && $filter_by_tags){
		$filter_by_tags_display = $helper->getTags();
		$filter_by_tags_label = $helper->getLabel($params->get('filter_by_tags_fieldtype', 'select'), 'tags_id', JText::_('MOD_K2_FILTER_TAGS'));
	}
	
	//rating
	$filter_by_rating_display = '';
	if($use_standard_fields && $filter_by_rating){
		$filter_by_rating_display = $helper->getRatings();
	}

	//ordering
	$display_ordering = $helper->getOrderingList();

	//theme
	$theme = $params->get('theme', '');

	require JModuleHelper::getLayoutPath('mod_sj_k2_filter', $params->get('layout', 'default'));
}else{
	echo JText::_('COMPONENT_K2_NOT_FOUND');
}