/*
 * @package Sj K2 Filter
 * @version 1.1.0
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @copyright (c) 2016 YouTech Company. All Rights Reserved.
 * @author YouTech Company http://www.smartaddons.com
 *
 */

function SjK2ShowDaterange(obj, range) {
    if(jQuery(obj).val() == 'range') {
        jQuery(range).show();
    } else {
        jQuery(range).hide();
    }
}

function sjk2AjaxStart() {
    if(!jQuery('#ajax-loading').length) {
        jQuery('body').append('<div id="ajax-loading"></div>');
    }
    jQuery('#ajax-loading').css({'display': 'block'});
}

function sjk2DisplayExtraFields (moduleid, obj, selected_group) {
	var sOption = obj.getSelected();
	var group = sOption.getProperty('rel');
	var value = sOption.get("value");
	
	var parent = obj.getParent('.sj-k2-filter');
	var parentid = parent.id;
	
	$$('#'+parentid+' .exfield').each(function(item){
		magicid = $(item).get('id') .toString();
		if('m'+magicid){		
			if($(item).hasClass('opened')) {
				$(item).removeClass('opened');
				$(item).addClass('closed');
				$('m'+magicid).setStyle('display', 'none');
			} else if($(item).hasClass('closed')) {

			}
		}
	});

    if((value != 0 && group != '') || selected_group) {
        if(group == '') {
            group = selected_group;
        }
        jQuery('#'+parentid).find('.heading-group').each(function() {
            if(this.hasClass('heading-group-'+group)) {
                this.removeClass('ui-accordion-disabled ui-state-disabled');
                if(!this.hasClass('ui-state-active')) {
                    var accor = jQuery('#sj-extra-field-accordion-'+moduleid);
                    accor.accordion('activate', this);
                }
            } else {
                //clear value of extra fields in group that not associated with selected category
                this.addClass('ui-accordion-disabled ui-state-disabled');
                sjK2ResetSearch(moduleid, jQuery(this).next('.ui-accordion-content'), false);
            }
        });
    } else {
        jQuery('#'+parentid).find('.heading-group').removeClass('ui-accordion-disabled ui-state-disabled');
    }
}

function sjK2ResetSearch(moduleId, container, submitform)
{
    //var form = jQuery('#'+formId);
    if(typeof(container) == 'string') {
        container = jQuery('#'+container);
    }
	//reset input
    container.find('input[type=text], textarea').val('');

    //radio, checkbox
    container.find(':checked').each(function(item){
        jQuery(this).removeAttr('checked');
    });

    //select, multi-select
    container.find('select option:selected').each(function(item){
		jQuery(this).removeAttr('selected');
	});
	
	//reset magic select
    container.find('.sj-magic-select ul li').each(function(item)
	{
        jQuery(this).removeClass('selected');
	});
    container.find('.sj-magic-select-container').each(function(item)
	{
        jQuery(this).html('');
	});

    //reset range slider
    container.find('[name$="_sjcheck"]').each(function(el) {
        var sliders = jQuery('#slider_'+this.id.replace('_sjcheck', ''));
        if(sliders) {
            var val = this.value.split('|');
            sliders.slider('values', 0, val[0]);
            sliders.slider('values', 1, val[1]);
        }
    });

    //submit form?
    if(submitform) {
        if(container.prop('tagName').toLowerCase() != 'form') {
            var form = container.parents('form');
        } else {
            var form = container;
        }
        var autofilter = form.find('[name="btnSubmit"]').length;
        if(!autofilter) {
            if(typeof(form.submit) == 'function') {
                form.submit();
            }
        }
    }
}

function sjMagicInit(lid, fid) {
	$$('#'+lid+' li').each(function(item){
		if(item.hasClass('selected')) {
			sjMagicAddElement(lid, fid, item.innerHTML, item.getProperty('rel'));
		}
	});

	$$('#'+lid+' li.active').each(function(item){
		item.addEvent('click', function() {
			var id = this.getProperty('rel');
			if(!id) return;
			
		    if(this.hasClass('selected')) {
		    	this.removeClass('selected');
		    	$(lid+'-'+id).dispose();
		    } else {
		    	this.addClass('selected');
		    	sjMagicAddElement(lid, fid, this.innerHTML, id);
		    }
		    var autofilter = $(lid).getProperty('data-autofilter');
		    if(autofilter == 1) {
		    	$(lid).getParent('form').fireEvent('submit');
		    }
		});
	    
	});
}

function sjMagicAddElement(lid, fid, label, id) {
	var container = $(lid+'-container');
	var el = new Element('span', {
			id: lid+'-'+id,
		    html: label + '<input type="hidden" name="'+fid+'[]" value="'+id+'" />'
		});
	var elRemove = new Element('span', {
			title: 'Remove',
			'class': 'remove',
			rel: id,
		    html: '',
		    events: {
		        click: function(){
		        	var lid = (this.getParent().id).replace(/^((?:[a-z0-9_]+\-){2}[a-z0-9_]*).*/, '$1');//id format: mg-moduleid-fieldid-value
		        	$$('#'+lid+' li[rel="'+this.getProperty('rel')+'"]').removeClass('selected');
		        	this.getParent().dispose();
		        	//auto search
				    var autofilter = $(lid).getProperty('data-autofilter');
				    if(autofilter == 1) {
				    	$(lid).getParent('form').fireEvent('submit');
				    }
		        }
		    }
		});
	el.grab(elRemove);
	container.grab(el);
}

function sjMagicSelect(controller, lid) {
	controller = $(controller);
	if(controller.hasClass('opened')) {
		controller.removeClass('opened');
		// controller.addClass('closed');
		$(lid).setStyle('display', 'none');
	} else {
		// controller.removeClass('closed');
		controller.addClass('opened');
		$(lid).setStyle('display', 'block');
	}
}
function sjMagicSelectClose(controller, lid) {
	controller = $(controller);
	controllerparent = $(lid).getParent('li').getElement('.select');
	if(controllerparent.hasClass('opened')) {
		controllerparent.removeClass('opened');
		// controllerparent.addClass('closed');
	} else {
		controllerparent.removeClass('closed');
		controllerparent.addClass('opened');
	}
	$(lid).setStyle('display', 'none');	
}

function sjk2AjaxSubmit(form, K2SitePath) {
	//if Container K2 does not exist, submit form to redirect to K2 Filter result page
    if(jQuery('#k2Container').length) {
        sjk2AjaxStart();
        jQuery.ajax({
            type: "POST",
            url: jQuery(form).attr('action'),
            data: jQuery(form).serialize(),
            success: function(text){
                sjK2ProcessAjax(text, K2SitePath);
            }
        });
    } else {
        jQuery(form).find('input[name="tmpl"]').val('');
        $(form).submit();
    }
}

function sjk2AjaxPagination(container, K2SitePath) {
    var pages = container.find('ul.pagination-list li a');
    if(!pages.length) {
        pages = container.find('.k2Pagination ul li a');
    }
    pages.each(function(){
        jQuery(this).click(function(event) {
            event.preventDefault();
            sjk2AjaxStart();
            jQuery.ajax({
                type: "GET",
                url: jQuery(this).attr('href'),
                success: function(text){
                    sjK2ProcessAjax(text, K2SitePath);
                }
            });
            return false;
        });
    });
}

function sjk2Highlight(container, searchword) {
    if(typeof(jQuery.fn.highlight) == 'function') {
        searchword = searchword.replace(/[<>#\\]/, '');
        //remove excluded words
        searchword = searchword.replace(/\-\s*(intitle\:|intext\:|inmetadata\:|inmedia\:)?\s*("[^"]"|[^\s]+)/g,'');
        //remove special keywords
        searchword = searchword.replace(/(intitle\:|intext\:|inmetadata\:|inmedia\:)/g,'');

        var pattern = /(?:"[^"]+"|[^\s]+)/gi;
        var matches = searchword.match(pattern);
        if(matches) {
            for(i=0; i<matches.length; i++) {
                var word = matches[i].replace(/"/g, '');
                if(word != '' && word != 'OR') {
                    container.highlight(word);
                }
            }
        }
    }
}

function sjK2ProcessAjax(text, K2SitePath) {
    // console.log(text);return false;
    var container = jQuery('#k2Container');
    var content = jQuery('<div>' + text + '</div>').find('#k2Container');
    if(content.length) {
        container.html(content.html());
        //paging
        sjk2AjaxPagination(container, K2SitePath);

        //rating
        container.find('.itemRatingForm a').click(function(event){
            event.preventDefault();
            var itemID = jQuery(this).attr('rel');
            var log = jQuery('#itemRatingLog' + itemID).empty().addClass('formLogLoading');
            var rating = jQuery(this).html();
            jQuery.ajax({
                url: K2SitePath+"index.php?option=com_k2&view=item&task=vote&format=raw&user_rating=" + rating + "&itemID=" + itemID,
                type: 'get',
                success: function(response){
                    log.removeClass('formLogLoading');
                    log.html(response);
                    jQuery.ajax({
                        url: K2SitePath+"index.php?option=com_k2&view=item&task=getVotesPercentage&format=raw&itemID=" + itemID,
                        type: 'get',
                        success: function(percentage){
                            jQuery('#itemCurrentRating' + itemID).css('width', percentage + "%");
                            setTimeout(function(){
                                jQuery.ajax({
                                    url: K2SitePath+"index.php?option=com_k2&view=item&task=getVotesNum&format=raw&itemID=" + itemID,
                                    type: 'get',
                                    success: function(response){
                                        log.html(response);
                                    }
                                });
                            }, 2000);
                        }
                    });
                }
            });
        });

        //highlight search team in result
        sjk2Highlight(container, jQuery('.sj-k2-filter input[name="searchword"]').val());
    } else {
        container.html('No Item found!');
    }

    jQuery('#ajax-loading').css({'display': 'none'});
	jQuery('html, body').animate({scrollTop: container.offset().top}, 1000);
}