<?php
/**
* @package Sj Basic News
* @version 3.0
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
* @copyright (c) 2012 YouTech Company. All Rights Reserved.
* @author YouTech Company http://www.smartaddons.com
*
*/
defined('_JEXEC') or die;

if(!empty($list)){
	$uniquied = 'sj_basic_news_'.time().rand();
	JHtml::stylesheet('modules/mod_sj_basic_news/assets/css/sj-basic-news.css');
	ImageHelper::setDefault($params);
?>
	<?php if($params->get('pretext') != null) {?>
		<div class="bs-pretext">
			<?php echo $params->get('pretext'); ?>
		</div>
	<?php }?>
	<div id="<?php echo $uniquied?>" class="sj-basic-news">
		<div class="item-inner">
			<?php  $i = 0;  foreach($list as $item){ $i++;
				$show_line = ($params->get('showline') == 1)?' bs-show-line':'';
				$last_class = ($i == count($list))?' last':'';
				$img = SjBasicNewsHelper::getAImage($item, $params);
			?>
			<div class="item-detail num-<?php echo $i; ?>">
				<div class="item_content">
					<?php if($img){?>
					<div class="item-img">
						<a class="item_title" href="<?php echo $item->link ?>" title="<?php echo $item->title; ?>" <?php echo SjBasicNewsHelper::parseTarget($params->get('link_target')); ?>><?php
	    					 echo SjBasicNewsHelper::imageTag($img);
	    				?></a>
					</div>
					<?php } ?>
					<div class="entry-content">
						<?php if($params->get('title_display') == 1) {?>
							<div class="item-title">
								<h4><a href="<?php echo $item->link ?>" title="<?php echo $item->title; ?>" <?php echo SjBasicNewsHelper::parseTarget($params->get('link_target')); ?>><?php echo SjBasicNewsHelper::truncate($item->title, $params->get('item_title_max_characs',25)); ?></a>	</h4>
							</div>
						<?php }?>						
						<?php if($params->get('cat_title_display') == 1 ){?>
							<a href="<?php echo $item->catlink; ?>" title="<?php echo $item->category_title; ?>" <?php echo SjBasicNewsHelper::parseTarget($params->get('link_target')); ?> >
								<?php echo $item->category_title; ?>
							</a>
						<?php } ?>
						<div class="item-meta clearfix">
                        	<div class="entry-date pull-left"><?php echo '<i class="fa fa-clock-o"></i> '.JHtml::_('date', $item->created, 'd M, Y'); ?>
                            </div>
                            <div class="pull-left"><?php echo '<i class="fa fa-user"></i> By <a href="#">'. $item->author.'</a>'; ?></div>
						</div>	
					</div>
					<?php if($params->get('item_desc_display') == 1) {?>
						<div class="bs-description">
							<?php echo SjBasicNewsHelper::truncate($item->introtext, $params->get('item_desc_max_characs',200)); ?>
						</div>
					<?php } ?>
				</div>
			</div>
			<?php } ?>
		</div>
	<?php if($params->get('posttext') != null) {?>
	<div class="bs-posttext">
		<?php echo $params->get('posttext'); ?>
	</div>
	<?php }?>	
	</div>
<?php 
}else{
	echo JText::_('Has no content to show!');	
}?>